// Calculates texture-space velocity of the current pixel
float2 CalcVelocity(float4 curViewportPos, float4 prevViewportPos) {
	// Make sure positions aren't in homogenous space
	curViewportPos /= curViewportPos.w;
	prevViewportPos /= prevViewportPos.w;

	// Use this frame's position and last frame's to compute the pixel velocity.  
	// The value is divided by 2 to convert from viewport space (position range [-1,1]) to texture space (position range [0,1]).
	float2 velocity = (curViewportPos - prevViewportPos).xy * float2(0.5f, -0.5f); // y needs to be negated as the axis flips 

	return velocity;
}